<?php 
$pageTitle = 'Inscription';
include 'templates/header.php'; 
?>

<div class="row">
    <div class="col-md-6 mx-auto">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h2 class="mb-0">Créer un compte</h2>
            </div>
            <div class="card-body">
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?php echo htmlspecialchars($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php elseif (!empty($successMessage)): ?>
                    <div class="alert alert-success">
                        <?php echo htmlspecialchars($successMessage); ?>
                    </div>
                <?php endif; ?>
                
                <form action="index.php?action=register_process" method="post" novalidate>
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token'] ?? ''); ?>">
                    
                    <div class="mb-3">
                        <label for="nom" class="form-label">Nom d'utilisateur</label>
                        <input type="text" class="form-control <?php echo isset($errors['nom']) ? 'is-invalid' : ''; ?>" 
                               id="nom" name="nom" 
                               value="<?php echo htmlspecialchars($nom ?? ''); ?>" 
                               required
                               minlength="3"
                               maxlength="30"
                               pattern="[a-zA-Z0-9_]+"
                               title="Lettres, chiffres et underscores seulement">
                        <div class="invalid-feedback">
                            <?php echo htmlspecialchars($errors['nom'] ?? ''); ?>
                        </div>
                        <small class="text-muted">3 à 30 caractères (lettres, chiffres, underscores)</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="email" class="form-label">Adresse e-mail</label>
                        <input type="email" class="form-control <?php echo isset($errors['email']) ? 'is-invalid' : ''; ?>" 
                               id="email" name="email" 
                               value="<?php echo htmlspecialchars($email ?? ''); ?>" 
                               required>
                        <div class="invalid-feedback">
                            <?php echo htmlspecialchars($errors['email'] ?? ''); ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="password" class="form-label">Mot de passe</label>
                        <input type="password" class="form-control <?php echo isset($errors['password']) ? 'is-invalid' : ''; ?>" 
                               id="password" name="password" 
                               required
                               minlength="8"
                               data-bs-toggle="password">
                        <div class="invalid-feedback">
                            <?php echo htmlspecialchars($errors['password'] ?? ''); ?>
                        </div>
                        <small class="text-muted">Minimum 8 caractères</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Confirmer le mot de passe</label>
                        <input type="password" class="form-control <?php echo isset($errors['confirm_password']) ? 'is-invalid' : ''; ?>" 
                               id="confirm_password" name="confirm_password" 
                               required
                               minlength="8">
                        <div class="invalid-feedback">
                            <?php echo htmlspecialchars($errors['confirm_password'] ?? ''); ?>
                        </div>
                    </div>
                    
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="terms" name="terms" required>
                        <label class="form-check-label" for="terms">
                            J'accepte les <a href="index.php?action=terms" target="_blank">conditions d'utilisation</a>
                        </label>
                        <?php if (isset($errors['terms'])): ?>
                            <div class="text-danger"><?php echo htmlspecialchars($errors['terms']); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary btn-lg">S'inscrire</button>
                    </div>
                </form>
                
                <div class="mt-3 text-center">
                    <p>Déjà un compte ? <a href="index.php?action=login">Connectez-vous</a></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'templates/footer.php'; ?>