<?php
// index.php - Point d'entrée principal de l'application

// Configuration initiale
//declare(strict_types=1);
session_start([
    'cookie_lifetime' => 86400,
    'cookie_secure' => false, // Mettre à true en production avec HTTPS
    'cookie_httponly' => true,
    'use_strict_mode' => true
]);

// Inclure les contrôleurs
require_once 'controllers/UserController.php';
require_once 'controllers/ContributionController.php';
require_once 'controllers/ProjectsController.php';



// Niveau de rapport d'erreurs
error_reporting(E_ALL);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');

// Constantes de l'application
define('APP_ROOT', dirname(__DIR__));
define('VIEW_PATH', APP_ROOT . '/views');
define('BASE_URL', 'https://communify.arsenetekeutech.com/');
https://communify.arsenetekeutech.com/
// Autoloader personnalisé (alternative à composer)
spl_autoload_register(function ($class) {
    $file = APP_ROOT . '/' . str_replace('\\', '/', $class) . '.php';
    if (file_exists($file)) {
        require $file;
    }
});

// Fonctions utilitaires
function getIntParam(string $key, int $default = 0): int
{
    return isset($_GET[$key]) ? (int)$_GET[$key] : $default;
}
function getStringParam(string $key, string $default = ''): string
{
    return isset($_GET[$key]) ? (string)$_GET[$key] : $default;
}

function sanitizeInput(string $input): string
{
    return htmlspecialchars($input, ENT_QUOTES, 'UTF-8');
}

function redirect(string $location, int $statusCode = 302): void
{
    header("Location: $location", true, $statusCode);
    exit;
}

// Initialisation des contrôleurs
try {
    $userController = new UserController();
    $contributionController = new ContributionController();
    $projectControllers = new ProjectsController();    
    

} catch (Exception $e) {
    error_log("Erreur d'initialisation : " . $e->getMessage());
    http_response_code(500);
    exit;
}

// Gestion du routage
$action = $_GET['action'] ?? 'home';

// Liste blanche des actions autorisées
$allowedActions = [
    'home', 'register', 'register_process', 'login', 'login_process','passwordforgot',
    'logout', 'profile', 'edit_profile', 'projects', 'project',
    'create_project','edit_project','edit_project_process', 'create_project_process', 'contribute',
    'contribute_process', 'my_contributions', 'admin_project_contributions', 'edit_profile_process', 
    'delete_project', 'delete_account', 'update_profile','updatepassword','updatepasswordprocess'
];

if (!in_array($action, $allowedActions)) {
    $action = 'home';
}

// Routeur principal
switch ($action) {
    case 'home':
        $userController->home();
        break;
    
    case 'register':
        $userController->showRegisterForm();
        break;
        
    case 'register_process':
        $userController->register();
        break;
        
    case 'login':
        $userController->showLoginForm();
        break;
        
    case 'login_process':
        $userController->login();
        break;
        
    case 'passwordforgot':
        $userController->forgotPassword();
        break;
        
    case 'logout':
        $userController->logout();
        break;
        
    case 'profile':
        $userController->showProfile();
        break;
    case 'edit_profile_process':
        $userController->updateProfile();
        break;
    case 'update_profile':
        $userController->updateProfile();
        break;
    case 'delete_account':
        $userController->deleteAccount();
        break;
    case 'delete_project':
        $projectControllers->delete();
        break;
    case 'edit_profile':
        $userController->showEditProfileForm();
        break;
    
    case  'updatepassword':
        $userController->updatepassword();
        break;
    case 'updatepasswordprocess':
        $userController->updatepasswordprocess();
        break;
    case 'projects':
        $projectControllers->index();
        break;
        
    case 'project':
        $projectControllers->showProjectDetails(getIntParam('id'));
        break;
        
    case 'create_project':
        $projectControllers->showCreateProjectForm();
        break;
        
    case 'create_project_process':
        $projectControllers->create();
        break;
    case 'edit_project':        
        $projectControllers->edit();
        break;
    case 'edit_project_process':
        $projectControllers->update();
        break;
    case 'contribute':
        $contributionController->showContributionForm(getIntParam('id'));
        break;
        
    case 'contribute_process':
        $contributionController->processContribution(getIntParam('id'));
        break;
        
    case 'my_contributions':
        $contributionController->showUserContributions();
        break;
        
    case 'admin_project_contributions':
        $contributionController->showProjectContributions(getIntParam('project_id'));
        break;
    default:
        $projectControllers->show();
        break;
}