<?php
$pageTitle = htmlspecialchars($projectDetails['categorie']);
include 'templates/header.php';

?>
<div class="container-fluid">
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Accueil</a></li>
                <li class="breadcrumb-item"><a href="index.php?action=projects">Projets</a></li>
                <li class="breadcrumb-item active" aria-current="page">
                    <?php echo htmlspecialchars($projectDetails['categorie']); ?></li>
            </ol>
        </nav>
    </div>

    <?php if (isset($_GET['contributed']) && $_GET['contributed'] == 1): ?>
        <div class="alert alert-success">
            Merci pour votre contribution ! Votre soutien est très apprécié.
        </div>
    <?php endif; ?>

    <div class="row mb-5">
        <div class="col-md-8">
            <h1><?php echo htmlspecialchars($projectDetails['titre']); ?></h1>
            <p class="text-muted">
                Porteur de projet : <span class="fw-bold"><?php echo htmlspecialchars($user['nom'] ?? ''); ?></span><br>
                catégorie du projet : <?php echo htmlspecialchars($projectDetails['categorie']); ?>
            </p>

            <div class="my-4">
                <div class="card mb-4">
                    <div class="card-body">
                        <!-- Image du projet si disponible -->
                        <div class="mb-4 text-center col-md-12">
                            <img src="/public/images/<?php echo htmlspecialchars($projectDetails['image']); ?>"
                                alt="<?php echo htmlspecialchars($projectDetails['titre']); ?>"
                                class="img-fluid rounded" style="height: 400px !important; width: 100%;">
                        </div>

                        <h4>Description du projet</h4>
                        <div class="project-description">
                            <?php echo nl2br(htmlspecialchars($projectDetails['description'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card sticky-top" style="top: 20px;">
                <div class="card-body">
                    <?php
                    $percentage = ($projectDetails['current_amount'] / $projectDetails['objectif']) * 100;
                    $percentage = min($percentage, 100);
                    $daysLeft = max(0, (strtotime($projectDetails['end_date']) - time()) / 86400);
                    ?>

                    <h4><?php echo number_format($projectDetails['current_amount'], 2); ?> FCFA</h4>
                    <p>collectés sur <?php echo number_format($projectDetails['objectif'], 2); ?> FCFA</p>

                    <div class="progress mb-3">
                        <div class="progress-bar" role="progressbar" style="width: <?php echo $percentage; ?>%"
                            aria-valuenow="<?php echo $percentage; ?>" aria-valuemin="0" aria-valuemax="100">
                            <?php echo round($percentage); ?>%
                        </div>
                    </div>
                    <p><strong><?php echo floor($daysLeft); ?></strong> jours restants</p>
                    <?php if ($projectDetails['current_amount'] >= $projectDetails['objectif']): ?>
                        <a href="#" class="btn btn-primary w-100">Contribuer</a>
                        <div class="alert alert-warning">
                            <p>Ce projet est <?php echo $projectDetails['statut']; ?></p>
                        </div>
                    <?php else: ?>
                        <a href="index.php?action=contribute&id=<?php echo $projectDetails['id']; ?>"
                            class="btn btn-primary w-100">Contribuer</a>
                    <?php endif; ?>

                    <div class="d-flex justify-content-between mt-3 w-auto">
                        <span>Date de fin: </span>
                        <span><?php echo date('d/m/Y', strtotime($projectDetails['end_date'])); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section class="mb-5">
        <h3>Contributeurs (<?php echo $contributions['donateurs_count']; ?>)</h3>

        <?php if (empty($contributions)): ?>
            <div class="alert alert-info">
                Ce projet n'a pas encore reçu de contributions. Soyez le premier à soutenir ce projet !
            </div>
        <?php else: ?>
            <div class="list-group">
                <?php foreach ($contributions['contributions'] as $contribution): ?>
                    <div class="list-group-item">
                        <div class="d-flex justify-content-between">
                            <h5 class="mb-1"><?php echo htmlspecialchars($contribution['nom']); ?></h5>
                            <span class="text-primary"><?php echo number_format($contribution['montant'], 2); ?> FCFA</span>
                        </div>
                        <?php if (!empty($contribution['message'])): ?>
                            <p class="mb-1"><?php echo htmlspecialchars($contribution['message']); ?></p>
                        <?php endif; ?>
                        <small class="text-muted">
                            Contribution du <?php echo date('d/m/Y à H:i', strtotime($contribution['created_at'])); ?>
                        </small>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </section>
    <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
            <div id="toast-success" class="toast align-items-center text-bg-success border-0" role="alert"
                aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body" id="toast-message">
                        <!-- Le message PHP du success de la contribution -->
                        <?php
                        if (isset($_SESSION['success'])) {
                            $msg = htmlspecialchars($_SESSION['success'], ENT_QUOTES, 'UTF-8');
                            echo "<script>
                                    window.addEventListener('DOMContentLoaded', function() {
                                        const toastEl = document.getElementById('toast-success');
                                        const toastMessage = document.getElementById('toast-message');
                                        toastMessage.innerHTML = '$msg';
                                        const toast = new bootstrap.Toast(toastEl);
                                        toast.show();
                                    });
                                </script>";
                            unset($_SESSION['success']);
                        }
                        ?>

                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                        aria-label="Close"></button>
                </div>
            </div>
        </div>
</div>
<?php include 'templates/footer.php'; ?>